/*Druhy modul v back-end casti kompileru, sestaven kodu do instrukci jazyka
Tento modul  vytvori spojovy seznam instrukci pro kazdou funkci
*/

//****************************************************************************************************************
//Trida jenz ma na praci vytvorit spojovy seznam instrukci pro kazdou funkci. Blok instrukci samozrejme musi
//provadet to same co kod zapsany ve vyssich konstrukcich
//****************************************************************************************************************
class	CCode
{
private:
	CInstruction*	m_CurrCodeStart;		//bude ukazovat na zacatek aktualniho bloku kodu
	CInstruction*	m_CurrCode;				//aktualni cast kodu
	LABEL*			m_CurrLabels;
private:
	void			AddInstruction(CInstruction* instruction);
private:
	//****************************************************************************************************************
	//Jednotlive funkce pro pridani urcite instrukce do spojoveho seznamu instrukci
	//****************************************************************************************************************
	void			instruct_nop();

	void			instruct_mul();
	void			instruct_neg();
	void			instruct_mod();
	void			instruct_sub();
	void			instruct_div();
	void			instruct_add();
	void			instruct_label(char* name, int label);
	void			instruct_lgoto(int label);
	void			instruct_ifeq(int label);
	void			instruct_ifne(int label);
	void			instruct_if_cmpeq(int label);
	void			instruct_if_cmpgt(int label);
	void			instruct_if_cmplt(int label);
	void			instruct_if_cmple(int label);
	void			instruct_if_cmpge(int label);
	void			instruct_if_cmpne(int label);
	void			instruct_nreturn();
	void			instruct_vreturn();
	void			instruct_load(int arg);
	void			instruct_store(int arg);
	void			instruct_dup();
	void			instruct_pop();
	void			instruct_ldc_int(int arg);
	void			instruct_ldc_string(char* arg);
	void			instruct_ldc_double(double arg);
	void			instruct_lcall(FUNCTION* arg);
	void			instruct_ecall(FUNCTION* arg,int args);
	void			instruct_shl();
	void			instruct_shr();
	void			instruct_dec();
	void			instruct_inc();
	void			instruct_or();
	void			instruct_and();
	void			instruct_store_lvalue(LVALUE* lvalue);

	//****************************************************************************************************************
	//Tyto funkce uz souvisi s pruchodem stromu
	//****************************************************************************************************************
	void			processTOPLEVEL(TOPLEVEL* toplevel);
	void			processFUNCTION(FUNCTION* function);
	void			processFORINIT(FORINIT* forinit);
	void			processSTATEMENT(STATEMENT* statement);
	void			processEXPRESSION(EXPRESSION* expression);
	void			processLVALUE(LVALUE* lvalue);
	void			processDECLARATION(DECLARATION* declaration);
public:
	void			Process(SCRIPT* theScript);
};